// RejestrSystemuWindowsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RejestrSystemuWindows.h"
#include "RejestrSystemuWindowsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CRejestrSystemuWindowsDlg dialog

#include "Rejestr.h"


CRejestrSystemuWindowsDlg::CRejestrSystemuWindowsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRejestrSystemuWindowsDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRejestrSystemuWindowsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CHECK1, checkBox1);
}

BEGIN_MESSAGE_MAP(CRejestrSystemuWindowsDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CHECK1, &CRejestrSystemuWindowsDlg::OnBnClickedCheck1)	
	ON_BN_CLICKED(IDC_BUTTON1, &CRejestrSystemuWindowsDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON3, &CRejestrSystemuWindowsDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON2, &CRejestrSystemuWindowsDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON4, &CRejestrSystemuWindowsDlg::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CRejestrSystemuWindowsDlg::OnBnClickedButton5)
END_MESSAGE_MAP()


// CRejestrSystemuWindowsDlg message handlers

BOOL CRejestrSystemuWindowsDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	
	if (!CzytajPolozenieIWielkoscOknaZRejestru(this->m_hWnd,L"Software\\Helion\\Przyklad\\Okno"))
	{
		MessageBox(L"Pierwsze uruchomienie programu");
	}

	checkBox1.SetCheck((int)CzyIstniejeZapisAutostart(HKEY_CURRENT_USER,AfxGetAppName()));


	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRejestrSystemuWindowsDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRejestrSystemuWindowsDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CRejestrSystemuWindowsDlg::OnDestroy()
{
	CDialog::OnDestroy();

	ZapiszPolozenieIWielkoscOknaWRejestrze(this->m_hWnd,L"Software\\Helion\\Przyklad\\Okno");
}

void CRejestrSystemuWindowsDlg::OnBnClickedCheck1()
{
	wchar_t sciezkaPliku[MAX_PATH]; GetModuleFileName(NULL,sciezkaPliku,MAX_PATH);
	if(checkBox1.GetCheck()) ZapiszAutostart(HKEY_CURRENT_USER,AfxGetAppName(),sciezkaPliku);
	else UsunAutostart(HKEY_CURRENT_USER,AfxGetAppName());
}

#include <exception>

void CRejestrSystemuWindowsDlg::OnBnClickedButton1()
{
	wchar_t sciezkaPliku[MAX_PATH];
	GetModuleFileName(NULL,sciezkaPliku,MAX_PATH);

	wchar_t katalogRoboczy[MAX_PATH];
	GetCurrentDirectory(MAX_PATH,katalogRoboczy);

	wchar_t nazwaAplikacji[1024];
	wcscpy_s(nazwaAplikacji,1024,AfxGetApp()->m_pszAppName);

	CDodajUsunInfo strukturaDodajUsun;
	strukturaDodajUsun.DisplayName="Tester edycji rejestru systemu Windows";
	strukturaDodajUsun.DisplayIcon=sciezkaPliku;
	strukturaDodajUsun.DisplayVersion=L"1.1";
	strukturaDodajUsun.Contact=L"jacek@phys.uni.torun.pl";
	strukturaDodajUsun.Publisher=L"Helion";
	strukturaDodajUsun.Comments=L"Aplikacja testujca moliwo edycji rejestru w Visual C++";
	strukturaDodajUsun.URLUpdateInfo=L"http://www.fizyka.umk.pl/~jacek/";
	strukturaDodajUsun.URLInfoAbout=L"http://helion.pl";
	strukturaDodajUsun.InstallLocation=katalogRoboczy;
	strukturaDodajUsun.InstallSource=katalogRoboczy;
	strukturaDodajUsun.UninstallString=sciezkaPliku+CString(" /uninstall");
	strukturaDodajUsun.UninstallPath=sciezkaPliku+CString(" /uninstall");
	strukturaDodajUsun.ModifyPath=sciezkaPliku+CString(" /modify");
	strukturaDodajUsun.HelpLink=L"http://www.fizyka.umk.pl/~jacek/";
	strukturaDodajUsun.VersionMajor=1;
	strukturaDodajUsun.VersionMinor=0;
	strukturaDodajUsun.NoRepair=1;
	strukturaDodajUsun.Language=-1; //nie zapisywana

	try
	{		
		if (!ZapiszDodajUsun(nazwaAplikacji,strukturaDodajUsun)) throw std::exception("Bd przy zapisywaniu informacji o instalacji");
		MessageBox(L"Klucz ("+CString(nazwaAplikacji)+L") z informacj o instalacji zosta utworzony.");
	}
	catch(std::exception& exc)
	{
		MessageBox(CString(exc.what()),L"Bd przy zapisywaniu informacji o instalacji",MB_ICONERROR);
	}
}

void CRejestrSystemuWindowsDlg::OnBnClickedButton2()
{
	if (UsunDodajUsun(AfxGetApp()->m_pszAppName)) MessageBox(L"Klucz z informacj o instalacji programu zosta usunity");
	else MessageBox(L"Usunicie klucza z informacj o instalacji programu nie powiodo si");
}

void CRejestrSystemuWindowsDlg::OnBnClickedButton3()
{
	ShellExecute(NULL,L"open",L"control.exe",L"appwiz.cpl",L"",SW_SHOW);
}

void CRejestrSystemuWindowsDlg::OnBnClickedButton4()
{
	wchar_t katalog[MAX_PATH];
	PobierzSciezkeDoKataloguMojeDokumenty(katalog);
	MessageBox(katalog);
}

void CRejestrSystemuWindowsDlg::OnBnClickedButton5()
{
	try
	{
		RozszerzMenuKontekstoweIstniejacegoTypuPliku(L"rtf",L"edit1",L"Poka ciek do pliku");
		MessageBox(L"Polecenie zostao dodane do menu kontekstowego plikw .rtf");
	}
	catch(std::exception& exc)
	{
		MessageBox(CString(exc.what()),L"Bd",MB_ICONERROR);
	}
}
